<?php
/**
 * Table Of Contents
 *
 * meridian_recipes_setup ( Sets up theme defaults and registers support for various WordPress features )
 * meridian_recipes_content_width ( Set the content width global variable )
 * meridian_recipes_register_sidebars ( Register sidebars )
 * meridian_recipes_scripts ( Enqueue scripts and styles )
 * meridian_recipes_admin_scripts ( Enqueue admin scripts and styles )
 * Include other files
 */

/**
 * Global Vars
 */

define( 'MERIDIAN_RECIPES_SOURCE', 'shop' );
define( 'MERIDIAN_RECIPES_THEME_VER', '1.1.2' );
define( 'MERIDIAN_RECIPES_CUSTOMIZER_PREPEND', 'meridian_recipes_theme_' );
define( 'MERIDIAN_RECIPES_CMB2_PATH', get_template_directory() . DIRECTORY_SEPARATOR . 'inc' . DIRECTORY_SEPARATOR . 'CMB2' );

if ( ! function_exists( 'meridian_recipes_setup' ) ) {

	/**
	 * Sets up theme defaults and registers support for various WordPress features
	 *
	 * @since 1.0
	 */
	function meridian_recipes_setup() {
		
		// Translation
		load_theme_textdomain( 'meridian-recipes', get_template_directory() . '/languages' );

		// Theme support
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );

		// Register Menus
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'meridian-recipes' ),
			'footer' => esc_html__( 'Footer', 'meridian-recipes' ),
			'side-panel' => esc_html__( 'Side Panel', 'meridian-recipes' ),
		) );

	}

} add_action( 'after_setup_theme', 'meridian_recipes_setup' );

if ( ! function_exists( 'meridian_recipes_content_width' ) ) {

	/**
	 * Set the content width global variable
	 *
	 * @since 1.0
	 * @global int $content_width
	 */
	function meridian_recipes_content_width() {
		
		$GLOBALS['content_width'] = apply_filters( 'meridian_recipes_content_width', 1254 );

	}

} add_action( 'after_setup_theme', 'meridian_recipes_content_width', 0 );

if ( ! function_exists( 'meridian_recipes_register_sidebars' ) ) {

	/**
	 * Register Sidebars
	 *
	 * @since 1.0
	 */
	function meridian_recipes_register_sidebars() {

		// Sidebar
		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar', 'meridian-recipes' ),
			'id'            => 'sidebar-1',
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector="#sidebar .widget-title" data-mtst-label="Sidebar - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// user profile
		register_sidebar( array(
			'name'          => esc_html__( 'User Profile', 'meridian-recipes' ),
			'id'            => 'sidebar-user-profile',
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector="#sidebar .widget-title" data-mtst-label="Sidebar - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// module 4
		register_sidebar( array(
			'name'          => esc_html__( 'Module 4 - Sidebar', 'meridian-recipes' ),
			'id'            => 'sidebar-m-4',
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector=".sidebar .widget-title" data-mtst-label="Module - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// module 6
		register_sidebar( array(
			'name'          => esc_html__( 'Module 6 - Sidebar', 'meridian-recipes' ),
			'id'            => 'sidebar-m-6',
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector=".sidebar .widget-title" data-mtst-label="Module - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// module 8
		register_sidebar( array(
			'name'          => esc_html__( 'Module 8 - Sidebar', 'meridian-recipes' ),
			'id'            => 'sidebar-m-8',
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector=".sidebar .widget-title" data-mtst-label="Module - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// module 9
		register_sidebar( array(
			'name'          => esc_html__( 'Module 9 - Sidebar', 'meridian-recipes' ),
			'id'            => 'sidebar-m-9',
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector=".sidebar .widget-title" data-mtst-label="Module - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// module 11
		register_sidebar( array(
			'name'          => esc_html__( 'Module 11 - Sidebar', 'meridian-recipes' ),
			'id'            => 'sidebar-m-11',
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector=".sidebar .widget-title" data-mtst-label="Module - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// module 12
		register_sidebar( array(
			'name'          => esc_html__( 'Module 12 - Sidebar', 'meridian-recipes' ),
			'id'            => 'sidebar-m-12',
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector=".sidebar .widget-title" data-mtst-label="Module - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// footer column 1
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Column 1', 'meridian-recipes' ),
			'id'            => 'sidebar-2',
			'before_widget' => '<section id="%1$s" class="widget %2$s" data-mtst-selector="#footer-widgets .widget" data-mtst-label="Footer - Widget">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector="#footer .widget-title" data-mtst-label="Footer - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// footer column 2
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Column 2', 'meridian-recipes' ),
			'id'            => 'sidebar-3',
			'before_widget' => '<section id="%1$s" class="widget %2$s" data-mtst-selector="#footer-widgets .widget" data-mtst-label="Footer - Widget">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector="#footer .widget-title" data-mtst-label="Footer - Widget Title">',
			'after_title'   => '</h2>',
		) );

		// footer column 3
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Column 3', 'meridian-recipes' ),
			'id'            => 'sidebar-4',
			'before_widget' => '<section id="%1$s" class="widget %2$s" data-mtst-selector="#footer-widgets .widget" data-mtst-label="Footer - Widget">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title" data-mtst-selector="#footer .widget-title" data-mtst-label="Footer - Widget Title">',
			'after_title'   => '</h2>',
		) );

	}

} add_action( 'widgets_init', 'meridian_recipes_register_sidebars' );

if ( ! function_exists( 'meridian_recipes_scripts' ) ) {
	
	/**
	 * Enqueue scripts and styles
	 *
	 * @since 1.0
	 */
	function meridian_recipes_scripts() {

		// Styles
		wp_enqueue_style( 'meridian-recipes-style', get_stylesheet_uri(), array(), MERIDIAN_RECIPES_THEME_VER );
		wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/fonts/font-awesome/font-awesome.css' );
		wp_enqueue_style( 'meridian-recipes-plugins', get_template_directory_uri() . '/css/plugins.css' );
		wp_enqueue_style( 'meridian-rercipes-print-style', get_template_directory_uri() . '/print.css', array(), MERIDIAN_RECIPES_THEME_VER, 'print' );

		// Scripts
		wp_enqueue_script( 'meridian-recipes-plugins-js', get_template_directory_uri() . '/js/plugins.js', array( 'jquery', 'jquery-effects-core' ), MERIDIAN_RECIPES_THEME_VER, true );
		wp_enqueue_script( 'meridian-recipes-main-js', get_template_directory_uri() . '/js/main.js', array(), MERIDIAN_RECIPES_THEME_VER, true );
		wp_localize_script( 'meridian-recipes-main-js', 'MeridianAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );

		// Google Fonts
		wp_enqueue_style( 'meridian-recipes-google-fonts', meridian_recipes_fonts_url(), array(), '1.0.0' );

		// Comment reply script
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

	}

} add_action( 'wp_enqueue_scripts', 'meridian_recipes_scripts' );

if ( ! function_exists( 'meridian_recipes_fonts_url' ) ) {

	/**
	 * Returns the google fonts URL
	 *
	 * @since 1.0
	 */
	function meridian_recipes_fonts_url() {
		
		$font_url = '';

		/*
		Translators: If there are characters in your language that are not supported
		by chosen font(s), translate this to 'off'. Do not translate into your own language.
		*/
		$font_state = _x( 'on', 'Google fonts: on or off', 'meridian-recipes' );
		if ( 'off' !== $font_state ) {
			$font_url = add_query_arg( 'family', urlencode( 'Vollkorn:400,700,400italic|Lato:400,300,400italic,700,700italic' ), "//fonts.googleapis.com/css" );
		}

		return $font_url;
	}

}

if ( ! function_exists( 'meridian_recipes_admin_scripts' ) ) {
	
	/**
	 * Enqueue admin scripts and styles
	 *
	 * @since 1.0
	 */
	function meridian_recipes_admin_scripts() {

		wp_enqueue_style( 'meridian-recipes-admin-css', get_template_directory_uri() . '/css/admin.css' );
		wp_enqueue_script( 'meridian-recipes-admin-js', get_template_directory_uri() . '/js/admin.js' );

	} 

} add_action( 'admin_enqueue_scripts', 'meridian_recipes_admin_scripts' );

// Include TGM Init ( plugin activation )
include get_template_directory() . '/inc/tgm/tgm-init.php';

// Include Frameworks & Options
include get_template_directory() . '/inc/post-options.php';
include get_template_directory() . '/inc/user-options.php';
include get_template_directory() . '/inc/theme-options.php';
include get_template_directory() . '/inc/importer/init.php';

// Include Other
include get_template_directory() . '/inc/functions.featured.php';
include get_template_directory() . '/inc/functions.php';
include get_template_directory() . '/inc/display-functions.php';
include get_template_directory() . '/inc/ajax.php';
include get_template_directory() . '/inc/welcome.php';

// Include Widgets
include get_template_directory() . '/inc/widgets/widget.author.php';
include get_template_directory() . '/inc/widgets/widget.posts.php';
include get_template_directory() . '/inc/widgets/widget.subscribe.php';
include get_template_directory() . '/inc/widgets/widget.social.php';
include get_template_directory() . '/inc/widgets/widget.instagram.php';
include get_template_directory() . '/inc/widgets/widget.search.php';

// updates
if ( MERIDIAN_RECIPES_SOURCE == 'themeforest' ) {
	include get_template_directory() . '/inc/tf-updates.php';
} else {
	function meridian_recipes_theme_updater() {
		require( get_template_directory() . '/inc/mt-updater.php' );
	} add_action( 'after_setup_theme', 'meridian_recipes_theme_updater' );
}