<?php
/**
 * Easy Digital Downloads Theme Updater
 */

define( 'MT_UPDATES_REMOTE_API_URL', 'http://meridianthemes.net' );
define( 'MT_UPDATES_ITEM_NAME', 'Florentine' );
define( 'MT_UPDATES_THEME_SLUG', 'meridian-recipes' );
define( 'MT_UPDATES_AUTHOR', 'MeridianThemes' );
define( 'MT_UPDATES_DOWNLOAD_ID', '29' );

// Includes the files needed for the theme updater
if ( !class_exists( 'Meridian_Recipes_Updater_Admin' ) ) {
	include( get_template_directory() . '/inc/mt-updater-admin.php' );
}

// Loads the updater classes
$updater = new Meridian_Recipes_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => MT_UPDATES_REMOTE_API_URL,
		'item_name'      => MT_UPDATES_ITEM_NAME,
		'theme_slug'     => MT_UPDATES_THEME_SLUG,
		'version'        => MERIDIAN_RECIPES_THEME_VER,
		'author'         => MT_UPDATES_AUTHOR,
		'download_id'    => MT_UPDATES_DOWNLOAD_ID,
		'renew_url'      => '',
		'beta'           => false,
	),

	// Strings
	$strings = array(
		'theme-license'             => esc_html__( 'Theme License', 'meridian-recipes' ),
		'enter-key'                 => esc_html__( 'Enter your theme license key.', 'meridian-recipes' ),
		'license-key'               => esc_html__( 'License Key', 'meridian-recipes' ),
		'license-action'            => esc_html__( 'License Action', 'meridian-recipes' ),
		'deactivate-license'        => esc_html__( 'Deactivate License', 'meridian-recipes' ),
		'activate-license'          => esc_html__( 'Activate License', 'meridian-recipes' ),
		'status-unknown'            => esc_html__( 'License status is unknown.', 'meridian-recipes' ),
		'renew'                     => esc_html__( 'Renew?', 'meridian-recipes' ),
		'unlimited'                 => esc_html__( 'unlimited', 'meridian-recipes' ),
		'license-key-is-active'     => esc_html__( 'License key is active.', 'meridian-recipes' ),
		'expires%s'                 => esc_html__( 'Expires %s.', 'meridian-recipes' ),
		'expires-never'             => esc_html__( 'Lifetime License.', 'meridian-recipes' ),
		'%1$s/%2$-sites'            => esc_html__( 'You have %1$s / %2$s sites activated.', 'meridian-recipes' ),
		'license-key-expired-%s'    => esc_html__( 'License key expired %s.', 'meridian-recipes' ),
		'license-key-expired'       => esc_html__( 'License key has expired.', 'meridian-recipes' ),
		'license-keys-do-not-match' => esc_html__( 'License keys do not match.', 'meridian-recipes' ),
		'license-is-inactive'       => esc_html__( 'License is inactive.', 'meridian-recipes' ),
		'license-key-is-disabled'   => esc_html__( 'License key is disabled.', 'meridian-recipes' ),
		'site-is-inactive'          => esc_html__( 'Site is inactive.', 'meridian-recipes' ),
		'license-status-unknown'    => esc_html__( 'License status is unknown.', 'meridian-recipes' ),
		'update-notice'             => esc_html__( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'meridian-recipes' ),
		'update-available'          => '<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.',
	)

);
